/*
 * @(#)CERRelationshipSet.java  1.1  2006-02-21
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.model;

import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import ch.hslu.cm.simulation.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.*;
import java.util.*;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;
/**
 * Represents a RelationshipSet element in a Conceptual Entity-Relationship Model.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.1 2006-02-21 Support for super-sub-type added.
 * <br>1.0 30. Januar 2004  Created.
 */
public class CERRelationshipSet extends AbstractElement 
implements DOMStorable {
    public final static int TYPE_STRONG = 0;
    public final static int TYPE_IDENTIFYING = 1;
    
    private int type = TYPE_STRONG;
    
    /** Creates a new instance. */
    public CERRelationshipSet() {
        ResourceBundleUtil labels = ConceptualERModel.labels;
        setName(labels.getString("relationshipSetDefaultName"));
    }
    
    public void setType(int newValue) {
        int oldValue = type;
        type = newValue;
        firePropertyChange("type", oldValue, newValue);
    }
    public int getType() {
        return type;
    }
    public Collection<CERConnection> getCERConnections() {
        LinkedList<CERConnection> relationships = new LinkedList<CERConnection>();
        for (SimulatedRelationship c : getRelationships()) {
            if (c.getSimulatedConcept() == ConceptualERModel.RELATIONSHIP_SET) {
                relationships.add((CERConnection) c);
            }
        }
        return relationships;
    }
    public Collection<CERRelationshipSet> getRelatedEntities() {
        LinkedList<CERRelationshipSet> entities = new LinkedList<CERRelationshipSet>();
        for (SimulatedElement e : getRelatedElements()) {
            if (e.getSimulatedConcept() == ConceptualERModel.ENTITY_SET) {
                entities.add((CERRelationshipSet) e);
            }
        }
        return entities;
    }
    /**
     * Returns linked attributes.
     */
    public List<CERAttribute> getAttributes() {
        LinkedList<CERAttribute> attributes = new LinkedList<CERAttribute>();
        for (SimulatedRelationship c : getRelationships(ConceptualERModel.ATTRIBUTE_LINK)) {
            attributes.add((CERAttribute) c.getConnected(c.getConnected(this)));
        }
        return attributes;
    }
    /**
     * Returns all associations defined by this class and all its superclasses.
     */
    public Collection<CERConnection> getAllRelations() {
        HashSet<CERConnection> list = new HashSet(getRelationships(ConceptualERModel.RELATIONSHIP_SET));
        return list;
    }
    protected CERAttribute createAttribute() {
        return new CERAttribute();
    }
    
    
    public int getSimulatedConcept() {
        return ConceptualERModel.RELATIONSHIP_SET;
    }
    
    public CERRelationshipSet clone() {
        CERRelationshipSet that = (CERRelationshipSet) super.clone();
        
        return that;
    }
    
    public void write(DOMOutput out) {
        out.addAttribute("name", name);
        out.addAttribute("type", type);
    }
    public void read(DOMInput in) {
        name = in.getAttribute("name", "Klasse");
        type = in.getAttribute("type", TYPE_STRONG);
    }
    public ConceptualERModel getERModel() {
        return (ConceptualERModel) getSimulation();
    }
    public boolean isEquivalent(SimulatedObject o) {
        if (super.isEquivalent(o) && (o instanceof CERRelationshipSet)) {
            CERRelationshipSet that = (CERRelationshipSet) o;
            
            // FIXME - Add more criteria
            if (that.getType() == this.getType()) {
                return true;
            }
        }
        return false;
    }
}
